using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace zec
{
    internal class Program
    {
        static void Main(string[] args)
        {
            int N = int.Parse(Console.ReadLine());

            List<int>[] graph = new List<int>[N + 1];
            for (int i = 1; i <= N; i++)
                graph[i] = new List<int>();

            for (int i = 1; i < N; i++)
            {
                string[] uv = Console.ReadLine().Split();
                int U = int.Parse(uv[0]);
                int V = int.Parse(uv[1]);
                graph[U].Add(V);
                graph[V].Add(U);
            }

            int[] platforms = Console.ReadLine().Split().Select(int.Parse).ToArray();
            int[] changes = Console.ReadLine().Split().Select(int.Parse).ToArray();

            int[] jumps = new int[N + 1];
            Queue<int> queue = new Queue<int>();

            for (int i = 1; i <= N; i++)
            {
                if (platforms[i - 1] == 1)
                {
                    jumps[i] = 0; // Pocetna vrednost za sobe sa platformama je 0
                    queue.Enqueue(i);
                }
                else
                {
                    jumps[i] = int.MaxValue;
                }
            }

            while (queue.Count > 0)
            {
                int current = queue.Dequeue();
                foreach (int neighbor in graph[current])
                {
                    if (jumps[current] + 1 < jumps[neighbor])
                    {
                        jumps[neighbor] = jumps[current] + 1;
                        queue.Enqueue(neighbor);
                    }
                }
            }

            for (int i = 1; i <= N; i++)
            {
                if (changes[i - 1] > 0)
                {
                    if (jumps[i] == int.MaxValue)
                    {
                        Console.Write("-1 ");
                    }
                    else
                    {
                        Console.Write((jumps[i] + changes[i - 1]) + " ");
                    }
                }
                else
                {
                    Console.Write(jumps[i] + " ");
                }
            }
            Console.Read();
        }
    }
}